# AR2000
from accpac import *

def main(args):
  MyUI()

class MyUI(UI):
	def __init__(self):
		UI.__init__(self)
		self.createScreen()

	def createScreen(self):
		self.getControlInfo("form|btnRefresh", self.onControlInfo)
		
		self.dsBatch = self.openDataSource("dsARIBC")
		self.dsHeader = self.openDataSource("dsARIBH")
		self.dsDetail = self.openDataSource("dsARIBD")
		
		self.show()

	def onControlInfo(self, info):
		f = info.find("form")
		b = info.find("btnRefresh")
		
		## Add a new button to create a batch and an invoice entry.
		ctrl = self.addButton("btnCreateBatch", "Create Test Batch")
		ctrl.height = b.height
		ctrl.left = b.left + b.width + 100
		ctrl.top = b.top - f.height
		ctrl.width = b.width + 500
		ctrl.onClick = self.btnCreateBatch_onClick
		self.btnCreateBatch = ctrl
		
		self.show()
		
	def btnCreateBatch_onClick(self):
	
		## Create a new batch with a single invoice entry.
		## This is only an example.
		
		## Create with insert
		r = self.dsBatch.recordGenerate(1)
		if eSUCCESS(r): r = self.dsBatch.put("BTCHDESC", "I am a test batch")
		if eSUCCESS(r): r = self.dsBatch.update()
		
		## Create the invoice header.
		if eSUCCESS(r): r = self.dsHeader.recordClear()
		if eSUCCESS(r): r = self.dsHeader.recordGenerate(2)			## Create with delayed key.
		if eSUCCESS(r): r = self.dsHeader.put("INVCTYPE", "2")		## Create as summary type invoice.
		if eSUCCESS(r): r = self.dsHeader.put("IDCUST", "1200")
		if eSUCCESS(r): r = self.dsHeader.put("PROCESSCMD", "4")
		if eSUCCESS(r): r = self.dsHeader.put("INVCDESC", "I am a summary type test invoice")
		if eSUCCESS(r): r = self.dsHeader.process()
		
		## Create a distribution detail for the invoice.
		if eSUCCESS(r): r = self.dsDetail.recordClear()
		if eSUCCESS(r): r = self.dsDetail.recordGenerate(0)			## Create with no insert.
		if eSUCCESS(r): r = self.dsDetail.process()
		if eSUCCESS(r): r = self.dsDetail.put("IDACCTREV", "1000")
		if eSUCCESS(r): r = self.dsDetail.put("AMTEXTN", "100.00")
		if eSUCCESS(r): r = self.dsDetail.insert()
		
		if eSUCCESS(r): r = self.dsHeader.insert()
		
		if eSUCCESS(r): r = self.dsBatch.update()
		
		if eSUCCESS(r): self.getHostControl("btnRefresh").click()
		
		if not eSUCCESS(r):
			errmsg = showErrorMsgs(True)
			msg = "Error creating invoice. {}".format(errmsg)
			showMessageBox(msg, "Error creating invoice")
			
		
################# End of MyUI Class ##################


def eSUCCESS(r):
	if r == Error_Success or r == Error_Warning:
		return True
	else:
		return False
	
def showErrorMsgs(bClearStack = False):
	
	errStack = getErrorStack()
	cnt = int(errStack.count())
	
	msg = ""
	fullmsg = ""
	if cnt > 0:
		i = 0
		for i in range(0, errStack.count()):
			msg = errStack.getText(i)
			fullmsg = fullmsg + "\n" + msg
		
		if bClearStack:
			errStack.clear()
	
	if fullmsg != "":
		fullmsg = fullmsg[1:]
		
	return fullmsg.strip()
