# OE1100
##############################################################################################################################
# Script for OE Sales Order entry.
# - item finder is overridden to filter only a single category if the APPROVED optional field is filled in. 
#   the finder will revert to its normal behavior and reference the I/C Item table if the APPROVED optional field is blank.
#   finder.viewID can be replaced to use a custom table. It doesn't have to be the I/C Item table
##############################################################################################################################
# Copyright 2020 Orchid Systems
# Permitted for use with Orchid Systems Modules only.
# The code is supplied on an  as-is basis for training and demonstration purposes only and is not supported by Orchid Systems.
# If this code is deployed in a live production environment it is the responsibility of the End User to ensure 
# that it is operating as required.
##############################################################################################################################

from accpac import *
import time
import datetime
import subprocess
import locale

from datetime import date, datetime, timedelta

####### Globals #########

def main(args):
	MyUI()

class MyUI(UI):
	def __init__(self):
		UI.__init__(self)
		self.createScreen()
		
	def createScreen(self):
	
		self.dsH = self.openDataSource("adsOEORDH")
		self.dsHO = self.openDataSource("dsOEORDHO")
		self.dsD = self.openDataSource("adsOEORDD")

		self.grid = self.getHostControl("avlOEORDDdetail1")
		self.grid.setOnFinder(self.onGridFinder)
		self.show()

	def onGridFinder(self, fieldName, caption):
		finder = Finder()
		
		if fieldName == "ITEM":
			
			sStatus = ""
			self.dsHO.recordClear()
			self.dsHO.put("OPTFIELD", "APPROVED")
			if self.dsHO.read() == 0:
				sStatus = self.dsHO.get("VALUE").strip()
		
			if sStatus != "":
				finder.viewID = "IC0310"
				finder.filter = "CATEGORY = \"" + "A1" + "\""
				finder.returnFields = "1"
				finder.onOK = self.finder_ok
				finder.onCancel = self.finder_cancel
				finder.show(self)

	def finder_ok(self, e):
		self.grid.endEdit(e)

	def finder_cancel(self):
		self.grid.preventFinder()
